<?php

namespace App\Models;

use CodeIgniter\Model;

class BiodataModel extends Model
{
    protected $table            = 'biodata';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'nama_lengkap', 'nama_panggilan', 'tempat_lahir', 'tanggal_lahir',
        'jenis_kelamin', 'alamat', 'kota', 'provinsi', 'kode_pos',
        'no_telepon', 'email', 'website', 'linkedin', 'github', 'instagram',
        'foto_profil', 'tentang_saya', 'keahlian', 'created_at', 'updated_at'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function getBiodata()
    {
        return $this->first();
    }

    public function searchAndFilter($search = '', $filter = [], $sort = 'nama_lengkap', $order = 'ASC')
    {
        $builder = $this->builder();

        if (!empty($search)) {
            $builder->groupStart()
                ->like('nama_lengkap', $search)
                ->orLike('nama_panggilan', $search)
                ->orLike('email', $search)
                ->orLike('kota', $search)
                ->groupEnd();
        }

        if (!empty($filter['kota'])) {
            $builder->where('kota', $filter['kota']);
        }

        if (!empty($filter['provinsi'])) {
            $builder->where('provinsi', $filter['provinsi']);
        }

        $allowedSorts = ['nama_lengkap', 'nama_panggilan', 'kota', 'created_at'];
        $sort = in_array($sort, $allowedSorts) ? $sort : 'nama_lengkap';
        $order = strtoupper($order) === 'DESC' ? 'DESC' : 'ASC';

        $builder->orderBy($sort, $order);

        return $builder;
    }
}

